#pragma rtGlobals=1		// Use modern global access method.
#include "mafutils"
#include "justfilters"

function prep(st,en)
	variable st,en
	variable i=st
	do
		wave w=$("ep_"+Num2Str(i))
		DeletePoints 0,600, w
		wavestats/q/r=[0,1500] w
		w-=v_avg
		i+=1
	while (i<=en)
end


function initmafmini (ctrlname) : ButtonControl
	string ctrlname
	variable/g wavenumber=0
	variable/g EPSC_ddtwidth, EPSC_ddtthreshold
	variable /g EPSC_binSize
	variable/g LowPass, HighPass, EPSC_boxWidth
	variable/g EPSC_MinAmp
	variable/g currentw
	string /g minibase
	
	string/g psth_destname
	variable/g psth_start, psth_end
	variable/g psth_binSize
	variable/g psth_miniStart, psth_miniEnd, psth_miniwidth, psth_minibin
	string/g psth_avgwave
	variable /g psth_alreadyinit
	
	if (!exists ("psth_skipTrials"))
		make /n=0 psth_skipTrials
	endif
	if (!exists ("psth_doTrials"))
		make /n=0 psth_doTrials
	endif
	if (!exists ("psth_eraseTimes"))
		Make /N=(2,2) psth_eraseTimes
	endif
	
	string mywinlist = WinList ("mafPSTH", ";", "WIN:64")
	if (strlen (mywinlist) == 0)
		execute "mafPSTH ()"
	endif
	
	if (psth_alreadyinit==0)
		epsc_ddtwidth = 1
		epsc_ddtthreshold = -10000
		lowpass = 500
		highpass = 0
		epsc_minamp=-5
		minibase = "w"
		psth_binsize = 1
		psth_miniwidth = .04
		psth_minibin = 10
		//psth_eraseTimes = {{}, {}}
		psthloadsettings ()
		psth_alreadyinit = 1
	endif
end

Function PSTHSaveSettings(ctrlName) : ButtonControl
	String ctrlName
	variable sfile	// file to hold settings
	variable tempval
	
	open /t="IGBW"/p=user_procedures sfile as "mafmini settings"
	fbinwrite sfile, minibase
	fbinwrite sfile, lowpass
	fbinwrite sfile, highpass
	fbinwrite sfile, epsc_ddtthreshold
	fbinwrite sfile, epsc_ddtwidth
	fbinwrite sfile, epsc_minamp
	fbinwrite sfile, psth_binsize
	fbinwrite sfile, psth_miniStart
	fbinwrite sfile, psth_miniwidth
	fbinwrite sfile, psth_minibin
	tempval = checkval ("CheckTrigger1", "mafPSTH") + checkval ("CheckTrigger2", "mafPSTH") * 2
	fbinwrite sfile, tempval
	close sfile
	Save /C/O/P=user_procedures psth_eraseTimes
End

function PSTHLoadSettings ()
	variable sfile	// file to hold settings
	variable tempval
	
	open /t="IGBW"/z/r/p=user_procedures sfile as "mafmini settings"
	if (v_flag == 0)	// i.e. file exists
		fbinread sfile, minibase
		fbinread sfile, lowpass
		fbinread sfile, highpass
		fbinread sfile, epsc_ddtthreshold
		fbinread sfile, epsc_ddtwidth
		fbinread sfile, epsc_minamp
		fbinread sfile, psth_binsize
		fbinread sfile, psth_miniStart
		fbinread sfile, psth_miniwidth
		fbinread sfile, psth_minibin
		fbinread sfile, tempval				// read what trigger should be - then set it
		string mywinlist = WinList ("mafPSTH", ";", "WIN:64")
		if (strlen (mywinlist) == 0)
			dowindow /f mafPSTH
			CheckBox CheckTrigger0 value=0, win=mafPSTH
			CheckBox CheckTrigger1 value=0, win=mafPSTH
			CheckBox CheckTrigger2 value=0, win=mafPSTH
			CheckBox $("CheckTrigger" + num2str (tempval)) value=1, win=mafPSTH
		endif
		close sfile
	endif
	controlupdate /a
	open /t="IGBW"/z/r/p=user_procedures sfile as "psth_eraseTimes.bwav"
	if (v_flag == 0)
		close sfile
		LoadWave /H/O/P=user_procedures/Q "psth_eraseTimes.bwav"
	endif
end

function LoadWaveIfNeeded (wavename)
	string wavename
	
	if (exists (wavename) != 0)
		return (0)
	endif
	LoadWave/q/P=home (wavename + ".bwav")
	if (exists (wavename) != 0)
		return (1)
	else
		print "Couldn't load \"" + wavename + "\""
		return (-1)
	endif
end

function ddtAndSmooth ()
	NVAR LowPass=LowPass, HighPass=Highpass
	WAVE psth_w=psth_w
	variable deriv=checkval ("checkTrigger1", "mafPSTH") + checkval ("checkTrigger2", "mafPSTH") * 2

	mi_fasterbpfilter (psth_w, highpass, LowPass , 4)	
	duplicate /o psth_w psth_dw
	differentiate psth_dw

	if (deriv == 2)
		duplicate /o psth_dw psth_d2w
		differentiate psth_d2w
//		smooth n, psth_d2w
	endif
end


function findPeaks ()
	NVAR thresh=EPSC_ddtthreshold, ddtwidth = EPSC_ddtwidth
	NVAR minamp=EPSC_MinAmp
	variable deriv=checkval ("checkTrigger1", "mafPSTH") + checkval ("checkTrigger2", "mafPSTH") * 2
	variable i = 0, j, wi, pointOK
	variable fastrise, baseline
	variable isEPSC, tempval
	string wavename
	WAVE psth_w=psth_w,psth_dw=psth_dw,psth_d2w=psth_d2w
	WAVE frequency=frequency
	NVAR wavenumber=wavenumber
	SVAR basename=basename, minibase=minibase
	wave psth_erasetimes = psth_erasetimes
	wavename = minibase + num2str (wavenumber)
	make /o/n=1000 $(wavename + "_x")		// to hold times of minis
	wave wx=$(wavename + "_x")
	if (deriv == 0)
		wave trigwave = psth_w
	endif
	if (deriv == 1)
		wave trigwave = psth_dw
	endif
	if (deriv == 2)
		wave trigwave = psth_d2w
	endif
	FindLevels /p/Q/D=wx trigwave, thresh		// /M=(ddtwidth/1000)
	wx = floor (wx + 1) 			// round up to next point
	
	duplicate /o wx $(wavename + "_peak"), $(wavename + "_peakslope")
	wave wpeak=$(wavename + "_peak")		// to hold peak heights of minis
	wave wpeakslope = $(wavename + "_peakslope")
	// first eliminate bad points, i.e. keep only upstrokes of derivatives, eliminate one point spikes
	i=0
	do
		pointOK = 1
		// eliminate edges going the wrong way & brief noise spikes		
		if (((trigwave[wx[i]] > thresh) %& (thresh < 0)) %| ((trigwave[wx[i]] < thresh) %& (thresh > 0)))
			pointOK = 0
		endif
		if ((pointOK == 1) %& (((trigwave[wx[i] + 1] > thresh) %& (thresh < 0)) %| ((trigwave[wx[i] + 1] < thresh) %& (thresh > 0))))
			pointOK = 0
		endif
		if (trigwave[wx[i]+10] > 6000)
			pointOK=0
		endif
		// eliminate artifacts
		j = 0
		do	
			if ((pnt2x (psth_w, wx[i]) >= psth_erasetimes[j][0]) %& (pnt2x (psth_w, wx[i]) <= psth_erasetimes[j][1]))
				pointOK = 0
			endif
			j += 1
		while ((j < dimsize (psth_erasetimes, 0)) %& (pointOK == 1))
		if (pointOK == 0)
			DeletePoints i, 1, wx, wpeak, wpeakslope
		else
			i += 1
		endif
		
	while (i < numpnts (wx))
	
	// now find peaks and peak slopes
	i=0
	do
		// find fast rise time
		if (thresh < 0)
			do
				wpeakslope[i] += 1
			while (psth_dw[wpeakslope[i] + 1] < psth_dw[wpeakslope[i]])	// while slope still dropping
		else
			do
				wpeakslope[i] += 1
			while (psth_dw[wpeakslope[i] + 1] > psth_dw[wpeakslope[i]])	// while slope still rising
		endif

		// find mini peak
		if (i < numpnts (wx) - 1)
			wavestats /q /r=[wpeakslope[i], min (wx[i+1], wpeakslope[i] + x2pnt (psth_w, ddtwidth/1000))] psth_w
		else
			wavestats /q /r=[wpeakslope[i], wpeakslope[i] + x2pnt (psth_w, ddtwidth/1000)] psth_w
		endif
		// convert to x-values, not pnts
		wx[i] = selectnumber (thresh < 0, v_maxloc, v_minloc)
		
		//	find baseline to work out peak height (avg of points just before mini)
//		baseline = mean (psth_w, wx[i] - ddtwidth / 1000 * 2, wx[i] - ddtwidth / 1000)	// old way of finding baseline
		// go looking for 0 crossing on derivative
		j = wpeakslope[i]
		wpeakslope[i] = pnt2x (psth_w, wpeakslope[i])
		if (thresh < 0)
			do
				j -= 1
			while ((j > 0) %& (psth_dw[j] < 0))	// %& (psth_dw[j - 1] > psth_dw[j]))	// find closest approach to zero in derivative
		else
			do
				j -= 1
			while ((j > 0) %& (psth_dw[j] > 0)) 	// %& (psth_dw[j - 1] < psth_dw[j]))	// find closest approach to zero in derivative		
		endif
		baseline = psth_w[j]
		wpeak[i] = selectnumber (thresh < 0, v_max, v_min) - baseline
		pointOK = 1
		if (((wpeak[i] > MinAmp) %& (thresh < 0)) %| ((wpeak[i] < MinAmp) %& (thresh > 0)))		// delete mini if too small
			pointOK = 0
		endif
		if ((wx[i] < ddtwidth/1000) %| (wx[i] > rightx (w) - ddtwidth/1000))
			pointOK = 0
		endif
		j = 0
		do
			if ((wx[i] >= psth_erasetimes[j][0]) %& (wx[i] <= psth_erasetimes[j][1]))
				pointOK = 0
			endif
			j += 1
		while ((j < dimsize (psth_erasetimes, 0)) %& (pointOK == 1))
		if (pointOK ==0)
			DeletePoints i, 1, wx, wpeak, wpeakslope		
		else
			i += 1
		endif
		
	while (i < numpnts (wx))

end


function makeMiniAmpHistogram (wstart, wend, destbase)
	variable wstart, wend
	string destbase
	string wname
	variable i, oldpnts
	
	SVAR minibase=minibase
	
	// get all EPSC peaks into one big wave called "destbase_peak"
	wave wpeak = $(minibase + num2str (wstart) + "_peak")
	duplicate /o wpeak $(destbase + "_peak")
	wave destpeak = $(destbase + "_peak")
	i = wstart + 1
	
	do
		wave wpeak = $(minibase + num2str (i) + "_peak")
		oldpnts = numpnts (destpeak)
		redimension/n=(oldpnts + numpnts (wpeak)) destpeak
		destpeak[oldpnts, oldpnts + numpnts (wpeak) - 1] = wpeak[p - oldpnts]
		i += 1
	while (i < wend)
	
	destpeak *= -1
	sort destpeak, destpeak
	make /n=(numpnts(destpeak))/o $(destbase + "_x")
	wave dx = $(destbase + "_x")
	dx = (p + 1)/numpnts (dx)
end


Function RasterButtonProc(ctrlName) : ButtonControl
	String ctrlName

	NVAR wstart=psth_start
	NVAR wend=psth_end
	SVAR destbase=psth_destname
	SVAR minibase = minibase
	variable i = wstart
	variable oldpnts
	variable /g $(destbase+"_psthcount")
	NVAR count=$(destbase+"_psthcount")
	count=0
	
	make /o/n=0 $(destbase + "_trial"), $(destbase + "_time")
	wave wtrial = $(destbase + "_trial")
	wave wtime = $(destbase + "_time")
	do
		wave w=$(minibase + num2str (i) + "_peakslope")
		// check that wave is in the doTrials list (if there is one) and not in the skipTrials list
		if (((numpnts (psth_dotrials) == 0) %| (findwaveval (psth_dotrials, i) != -1)) %& (findwaveval (psth_skiptrials, i) == -1) %& (numpnts (w) > 0) %& (exists (minibase + num2str (i) + "_peakslope")))
			count += 1
			oldpnts = numpnts (wtrial)
			redimension/n=(oldpnts + numpnts (w)) wtrial, wtime
			wtime[oldpnts, oldpnts + numpnts (w) - 1] = w[p - oldpnts]
			wtrial[oldpnts, oldpnts + numpnts (w) - 1] = i
		endif
		i += 1
	while (i <= wend)
	if (count == 0)
		doalert 0, "Warning: No waves rasterized."
	else
		PSTHBinSizeProc ("", 0, "", "")
	endif
end


Function EditArtifactProc(ctrlName) : ButtonControl
	String ctrlName
	string mywinlist = WinList ("EraseTimes", ";", "WIN:2")
	if (strlen (mywinlist) == 0)
		Edit /W=(487.5,414.5,703.5,592.25) psth_eraseTimes as "Erase Times"
		execute "ModifyTable width(Point)=0,width(psth_eraseTimes)=100"
		DoWindow/C EraseTimes
	else
		dowindow /f EraseTimes
	endif
End
Function EditSkipTrialsProc(ctrlName) : ButtonControl
	String ctrlName
	string mywinlist = WinList ("SkipWaves", ";", "WIN:2")
	if (strlen (mywinlist) == 0)
		Edit/W=(482.25,416,542,590.75) psth_skiptrials as "Skip Waves"
		DoWindow/C SkipWaves
		execute "ModifyTable width(Point)=0"
	else
		dowindow /f SkipWaves
	endif
end
Function DoWavesButtonProc(ctrlName) : ButtonControl
	String ctrlName

	string mywinlist = WinList ("DoWaves", ";", "WIN:2")
	if (strlen (mywinlist) == 0)
		Edit/W=(482.25,416,542,590.75) psth_dotrials as "Do Waves"
		DoWindow/C DoWaves
		execute "ModifyTable width(Point)=0"
	else
		dowindow /f DoWaves
	endif
End


Function PSTHBinSizeProc(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	variable endtime
	variable ILoadedIt
	SVAR destbase=psth_destname
	SVAR minibase=minibase
	NVAR psth_binsize=psth_binsize
	NVAR count=$(destbase + "_psthcount")

	if (!exists (destbase + "_time") %| (psth_binsize == 0))
		return (0)
	endif

	make /o/n=1 $(destbase + "_psth")
	wave wpsth = $(destbase + "_psth")
	wave wtime = $(destbase + "_time")
	wave wtrial = $(destbase + "_trial")
	ILoadedIt = LoadWaveIfNeeded (minibase + num2str (wtrial[0]))
	if (ILoadedIt == -1)
		abort ""
	endif
	endtime=rightx ($(minibase + num2str (wtrial[0])))
	if (ILoadedIt == 1)
		killwaves $(minibase + num2str (wtrial[0]))
	endif
	histogram /b={0, psth_binsize/1000, endtime / (psth_binsize / 1000)} wtime, wpsth
	wpsth /= count * psth_binsize /1000
end

Function PlotPSTHButtonProc(ctrlName) : ButtonControl
	String ctrlName

	SVAR destbase=psth_destname
	SVAR psth_avgwave=psth_avgwave
	NVAR miniwidth=psth_miniwidth
	
	wave wtrial = $(destbase + "_trial")
	wave wtime = $(destbase + "_time")
	display wtrial vs wtime
	textbox /b=1/f=0/a=rt destbase
	ModifyGraph mode($(destbase + "_trial"))=2,lsize($(destbase + "_trial"))=2
	SetAxis/A/R left
	setaxis /a/e=1 bottom
	label left "Trial #"
	if (exists (destbase + "_psth"))
		wave wpsth = $(destbase + "_psth")
		appendtograph /l=left2 wpsth
		ModifyGraph mode($(destbase + "_psth"))=6, lsize($(destbase + "_psth"))=0.5
		ModifyGraph zero(left2)=2
		label left2 "Events/trial/s"
		SetAxis/A/E=1 left2
		if (strlen (psth_avgwave) != 0)
			wave w=$psth_avgwave
			appendtograph /l=left3 w
			ModifyGraph lsize($psth_avgwave)=0.5
			ModifyGraph axisEnab(left)={0.7,1},axisEnab(left2)={.35,.65},axisEnab(left3)={0,.3},freePos(left2)=0, freePos(left3)=0
			if (exists (destbase + "_convolve") == 1)
				appendtograph /l=left3 $(destbase + "_convolve")
				ModifyGraph lsize($(destbase + "_convolve"))=0.5, lstyle($(destbase + "_convolve"))=1
			endif
		else
			ModifyGraph axisEnab(left)={0.6,1},axisEnab(left2)={0,.55},freePos(left2)=0
		endif
	endif
	//bg()
	ModifyGraph lblPos=48
end

Function AvgBlanks (blankstart, blankend)
	variable blankstart, blankend
	SVAR destbase=psth_destname
	SVAR minibase = minibase
	NVAR wstart=psth_start
	NVAR wend=psth_end
	SVAR matchvar=psth_var
	SVAR matchval=psth_val

	variable i=wstart, count = 0, j
	variable veto=0, firstone = 1
	wave wtrial = $(destbase + "_trial")
	wave wtime = $(destbase + "_time")
	printf "Finding blank trials: "
	j = 0
	do
		veto = 0

		// is there an event detected in the specified window?
		if (veto == 0)
			do
				if (wtrial[j] == i)
					if ((wtime[j] >= blankstart) %& (wtime[j] <= blankend))
						veto = 1
						break
					endif
				endif
				if (wtrial[j] > i)
					break
				endif
				j += 1
			while (j < numpnts (wtrial))
		endif
		if (veto == 0)
			wave w = $(minibase + num2str (i))
			if (firstone == 1)
				duplicate /o w $(destbase + "_blank")
				wave wblank = $(destbase + "_blank")
				count = 1
				printf "%s%d", minibase, i
				firstone = 0
			else
				wblank += w
				count += 1
				printf ", %s%d", minibase, i
			endif
		endif
		i += 1
	while (i <= wend)
	if (firstone == 1)
		print "none"
	else
		wblank /= count
		print " "
	endif
end

Function AvgMiniButtonProc(ctrlName) : ButtonControl
	String ctrlName
	
	SVAR destbase=psth_destname
	SVAR minibase = minibase
	NVAR EPSC_ddtwidth=EPSC_ddtwidth
	NVAR psth_ministart=psth_ministart
	NVAR psth_miniend=psth_miniend
	NVAR psth_miniwidth=psth_miniwidth
	NVAR psth_minibin=psth_minibin
	wave psth_erasetimes=psth_erasetimes
	variable goahead
	
	variable i=0, j
	variable silence = psth_miniwidth
	variable /g $(destbase + "_minicount")
	NVAR count = $(destbase + "_minicount")
	variable temptime
	wave psth_dw=psth_dw
	variable lasttrial=-1, thistrialcount, baseline, ILoadedIt
	string mywinlist, tempwinname
	
	wave wtrial = $(destbase + "_trial")
	wave wtime = $(destbase + "_time")
	make /o/n=0 $(destbase + "_mamp")
	wave wmamp = $(destbase + "_mamp")
	wave isi = isi
	wave w=w
	count = 0
	ILoadedIt = 0
	do
		goahead = 1
		// is it within the desired window?
		if (wtime[i] < psth_ministart)
			goahead = 0
		endif
		// is mini isolated from previous mini?
		if ((wtime[i - 1] > wtime[i] - silence) %& (i != 0) %& (wtrial[i - 1] == wtrial[i]))
			goahead = 0
		endif
		// is mini isolated from next mini?
		if ((wtime[i + 1] < wtime[i] + silence) %& (i < numpnts(wtime) - 1) %& (wtrial[i + 1] == wtrial[i]))
			goahead = 0
		endif
		// does it run off the end of the wave?
		if ((wtime[i] - silence < 0) %| (wtime[i] + silence > rightx ($(minibase + num2str (wtrial[i])))))
			goahead = 0
		endif
		// is mini too close to an erase time?
//		j = 0
//		do
//			if ((psth_erasetimes[j][0] > wtime[i] - silence) %& (psth_erasetimes[j][0] < wtime[i] + silence))
//				goahead = 0
//			endif
//			if ((psth_erasetimes[j][1] > wtime[i] - silence) %& (psth_erasetimes[j][1] < wtime[i] + silence))
//				goahead = 0
//			endif
//			j += 1
//		while (j < dimsize (psth_erasetimes, 0))
//		if (goahead == 0)
//			print "Skipping " + num2str (wtrial[i]) + " @ " + num2str (wtime[i])
//		endif
		if (goahead == 1)
			// have we moved onto the next trial yet?  If so, clear out old one if we loaded off disk
			if ((wtrial[i] != lasttrial) %& (ILoadedIt == 1))
				killwaves $(minibase + num2str (lasttrial))
				ILoadedIt = 0
			endif
			// load this trial if it isn't in memory
			if (exists (minibase + num2str (wtrial[i])) == 0)
				LoadWave /q/p=home (minibase + num2str (wtrial[i]) + ".bwav")
				if (exists (minibase + num2str (wtrial[i])) == 0)
					abort "Couldn't load " + minibase + num2str (wtrial[i])
				endif
				ILoadedIt = 1
				if (lasttrial == -1)
					Notebook Notebook1 selection={startOfFile, endOfFile}
				endif
				lasttrial = wtrial[i]
			endif
			
			wave w = $(minibase + num2str (wtrial[i]))
			if (count == 0)			// setup destination templates
				duplicate /o w $(destbase + "_mepsc")
				wave wmepsc = $(destbase + "_mepsc")
				redimension /n=(x2pnt (wmepsc, psth_miniwidth)) wmepsc
				SetScale/P x -psth_miniwidth / 2,deltax (wmepsc),"", wmepsc
				wmepsc = 0
			endif
			wmepsc += w(x + wtime[i])	// add mini to average
			redimension /n=(count + 1) wmamp							// now find its amp
			wavestats /Q/R=(wtime[i] - psth_miniwidth/2, wtime[i] + psth_miniwidth/2) w
			wmamp[count] = v_min
			
			// if trial was loaded, then write the mini into a temporary holder wave, and indicate where it came from
			if (ILoadedIt == 1)
				duplicate /o/r=(wtime[i] - psth_miniwidth/2, wtime[i] + psth_miniwidth/2) w $(destbase + "_mini" + num2str (count))
				wave wdisp = $(destbase + "_mini" + num2str (count))
				notebook notebook1 text="\r" + destbase + "_mini" + num2str (count) + "\t = " + minibase + num2str (wtrial[i]) + ",\tx = " + num2str (wtime[i])
			else
				wave wdisp = w
			endif
			if (count == 0)	//are we showing any minis yet?
				tempwinname = destbase + "_AllMinis"
				mywinlist = winlist (tempwinname, ";", "WIN:1")
				if (strlen (mywinlist) != 0)
					dowindow /k $tempwinname
				endif
				display wdisp
				dowindow /c $tempwinname
				setaxis bottom -silence/2, silence/2
				setaxis left -300, 30
			else
				appendtograph wdisp
			endif
			// line up by fast rise time
			baseline = mean (w, wtime[i] - silence, wtime[i] - silence/2)
			modifygraph offset[count] = {-wtime[i], -baseline}
			count += 1
		endif
		i += 1
	while (i < numpnts(wtime))
	textbox /b=1/f=0/a=rb destbase + " minis (" + num2str (count) + "/" + num2str (numpnts (wtime)) + ")"
	if (ILoadedIt == 1) // clear out loaded wave
		killwaves w
	endif
	//bg();tl()
	
	// fix up average mini
	wmepsc /= count
	k0=mean (wmepsc, leftx (wmepsc), leftx(wmepsc)/2)
	wmepsc -= k0
	tempwinname = destbase + "_ShowAvgMini"
	mywinlist = winlist (tempwinname, ";", "WIN:1")
	if (strlen (mywinlist) == 0)
		display wmepsc
		dowindow /c $tempwinname
		//bg();tl()
	endif
	
	// make isi cum histogram
	sort isi isi
	isi*=1000
	duplicate/o isi $(destbase + "_cumisi")
	wave w=$(destbase + "_cumisi")
	w = p/(numpnts(w)-1)
	display w vs isi
	
	//make amp histogram
	
	wmamp *= -1
	sort wmamp wmamp
	duplicate /o wmamp $(destbase + "_minihist")
	Histogram/B={0, psth_minibin, wmamp[numpnts (wmamp) - 1]/psth_minibin} wmamp,$(destbase + "_minihist")
	tempwinname = destbase + "_ShowMiniHist"
	mywinlist = winlist (tempwinname, ";", "WIN:1")
	if (strlen (mywinlist) == 0)
		display $(destbase + "_minihist")
		dowindow /c $tempwinname
		//bg();tl(); 
		modifygraph mode=6
		label bottom "Mini Amp (pA)"
		label left "Count"
	endif

	//make cumulative histogram
	
	duplicate /o wmamp $(destbase + "_cumamp")
	wave cumamp=$(destbase + "_cumamp")
	cumamp = p/(count-1)
	tempwinname = destbase + "_ShowMiniCumAmp"
	mywinlist = winlist (tempwinname, ";", "WIN:1")
	if (strlen (mywinlist) == 0)
		display cumamp vs wmamp
		dowindow /c $tempwinname
		//bg();tl(); 
		SetAxis/A/E=1 bottom
		label bottom "Mini Amp (pA)"
		label left "Cumulative Probability"
	endif

	miniconvolve ()
End


function miniConvolve ()
	SVAR destbase=psth_destname
	SVAR minibase=minibase
	wave wmepsc = $(destbase + "_mepsc")
	wave wtrial = $(destbase + "_trial")
	NVAR count=$(destbase + "_psthcount")
	
	duplicate /o $(minibase + num2str (wtrial[0])) $(destbase + "_convolve")
	wave wc=$(destbase + "_convolve")
	histogram /B=2 $(destbase + "_time"), wc
	wc /= count
	convolve wmepsc, wc
	SetScale/P x leftx (wmepsc), deltax (wc) ,"", wc
end

function integratePSTH (destbase)
	string destbase
	SVAR minibase=minibase
	wave wmepsc = $(destbase + "_mepsc")
	wave wtrial = $(destbase + "_trial")
	NVAR count=$(destbase + "_psthcount")
	NVAR psth_stimend=psth_stimend
	
	duplicate /o $(minibase + num2str (wtrial[0])) $(destbase + "_psthInt")
	wave wc=$(destbase + "_psthInt")
	histogram /B=2 $(destbase + "_time"), wc
	wc /= count
	integrate wc
	variable temp = wc(psth_stimend)
	wc -= temp
end

Window mafPSTH() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(794.25,56,977.25,512.75) as "mafPSTH"
	SetDrawLayer UserBack
	SetDrawEnv linethick= 2
	DrawLine 10,64,179,64
	SetDrawEnv fsize= 9
	SetDrawEnv save
	SetDrawEnv linethick= 2
	DrawLine 5,205,178,205
	DrawLine -26,279,261,279
	DrawLine -28,322,256,322
	DrawLine -47,364,241,364
	DrawLine 40,162,142,162
	SetDrawEnv fsize= 10
	DrawText 8,132,"Trigger"
	SetDrawEnv fsize= 10
	DrawText 7,79,"Filter"
	DrawRect 22,412,167,446
	SetVariable setvar1_1,pos={8,2},size={137,16},title="Source Prefix"
	SetVariable setvar1_1,limits={-Inf,Inf,1},value= minibase
	SetVariable setvar0,pos={20,20},size={125,16},title="Dest Name"
	SetVariable setvar0,limits={-Inf,Inf,1},value= psth_destname
	SetVariable setvar1,pos={8,42},size={102,16},proc=ReprocessField,title="Wave #"
	SetVariable setvar1,format="%g",limits={-Inf,Inf,1},value= currentw
	Button buttonProcess,pos={112,40},size={61,20},proc=mafprocessbutton,title="Inspect"
	SetVariable setvarFilterLow,pos={49,66},size={75,16},proc=ReprocessField,title="Freq (Hz)"
	SetVariable setvarFilterLow,format="%G",limits={0,Inf,0},value= HighPass
	SetVariable setvar2_6,pos={126,66},size={50,16},proc=ReprocessField,title="-"
	SetVariable setvar2_6,format="%G",limits={0,Inf,0},value= lowpass
	SetVariable PSTHThresh,pos={8,100},size={142,16},proc=ReprocessField,title="Threshold"
	SetVariable PSTHThresh,format="%g",limits={-Inf,Inf,0},value= EPSC_ddtthreshold
	Button button0_5,pos={43,137},size={100,20},proc=EditArtifactProc,title="Edit Artifacts..."
	SetVariable setvar2_1,pos={44,167},size={92,16},proc=ReprocessField,title="Width"
	SetVariable setvar2_1,format="%g ms",limits={-Inf,Inf,0},value= EPSC_ddtwidth
	SetVariable setvar2_2,pos={36,185},size={100,16},proc=ReprocessField,title="Min Amp"
	SetVariable setvar2_2,format="%g pA",limits={-Inf,Inf,0},value= EPSC_MinAmp
	SetVariable setvar10,pos={17,214},size={78,16},title="Waves"
	SetVariable setvar10,limits={-Inf,Inf,0},value= psth_start
	SetVariable setvar11,pos={97,214},size={51,16},title=""
	SetVariable setvar11,limits={-Inf,Inf,0},value= psth_end
	Button button1_1,pos={11,235},size={79,20},proc=DoWavesButtonProc,title="Do These..."
	Button button1,pos={91,235},size={83,20},proc=EditSkipTrialsProc,title="Skip These..."
	Button buttonRunThru,pos={60,257},size={65,20},proc=mafrunthru,title="Run Thru"
	Button buttonRasterize,pos={57,282},size={69,20},proc=RasterButtonProc,title="Rasterize"
	SetVariable setvar0_7,pos={15,303},size={98,16},proc=PSTHBinSizeProc,title="PSTH Bin"
	SetVariable setvar0_7,format="%G ms",limits={0,Inf,0},value= psth_binSize
	SetVariable setvar0_11,pos={11,324},size={74,16},title="Start",format="%G s"
	SetVariable setvar0_11,limits={0,Inf,0},value= psth_miniStart
	SetVariable setvar0_13,pos={88,324},size={84,16},title="Width",format="%G s"
	SetVariable setvar0_13,limits={0,Inf,0},value= psth_miniwidth
	SetVariable setvar0_5,pos={1,343},size={92,16},title="amp bin",format="%G pA"
	SetVariable setvar0_5,limits={1,Inf,0},value= psth_minibin
	Button button0_4,pos={105,341},size={67,20},proc=AvgMiniButtonProc,title="Avg Mini"
	SetVariable setvar0_10,pos={7,367},size={158,16},title="Wave Name"
	SetVariable setvar0_10,limits={-Inf,Inf,1},value= psth_avgwave
	Button button0_3,pos={64,385},size={58,20},proc=PlotPSTHButtonProc,title="Plot All"
	Button button0,pos={9,386},size={50,20},proc=PSTHSaveSettings,title="Save"
	CheckBox CheckTrigger0,pos={54,118},size={33,14},proc=TriggerCheckProc,title="0th"
	CheckBox CheckTrigger0,value= 0,mode=1
	CheckBox CheckTrigger1,pos={94,118},size={32,14},proc=TriggerCheckProc,title="1st"
	CheckBox CheckTrigger1,value= 1,mode=1
	CheckBox CheckTrigger2,pos={135,118},size={36,14},proc=TriggerCheckProc,title="2nd"
	CheckBox CheckTrigger2,value= 0,mode=1
	SetVariable setvarFilterBox,pos={49,83},size={54,16},proc=ReprocessField,title="Box"
	SetVariable setvarFilterBox,format="%G",limits={0,Inf,0},value= epsc_boxWidth
	CheckBox CheckFreqFilter,pos={34,66},size={16,14},proc=FilterCheckProc,title=""
	CheckBox CheckFreqFilter,value= 1,mode=1
	CheckBox CheckBoxFilter,pos={34,83},size={16,14},proc=FilterCheckProc,title=""
	CheckBox CheckBoxFilter,value= 0,mode=1
	Button button2,pos={55,419},size={82,20},proc=initmafmini,title="Initialize"
EndMacro

Function TriggerCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	variable trigsource
	string mywinlist
	WAVE psth_w=psth_w, psth_dw=psth_dw, psth_d2w=psth_d2w, psth_thresh=psth_thresh
	
	CheckBox CheckTrigger0 value=0, win=mafPSTH
	CheckBox CheckTrigger1 value=0, win=mafPSTH
	CheckBox CheckTrigger2 value=0, win=mafPSTH
	CheckBox $ctrlName value=1, win=mafPSTH
	trigsource = str2num (ctrlName[12])
	
	// is inspect window around?
	mywinlist = WinList ("InspectWindow", ";", "WIN:1")
	if (strlen (mywinlist) != 0)
		dowindow/f inspectwindow
		// yes, so rearrange axes, and move psth_thresh
		removefromgraph psth_thresh
		if (trigsource==2)
			if (!exists ("psth_d2w"))
				duplicate psth_dw psth_d2w
			endif
			appendtograph/l=left3 psth_d2w, psth_thresh
			setaxis left3 -1e9, 1e9
			ModifyGraph freePos(left3)=0
			ModifyGraph axisEnab(left)={0,0.30}, axisEnab(left2)={0.35,.65}, axisEnab(left3)={0.70,1}
		else
			removefromgraph /z psth_d2w
			ModifyGraph axisEnab(left)={0,0.45}, axisEnab(left2)={0.55,1}
			if (trigsource == 1)
				appendtograph /l=left2 psth_thresh
			else
				appendtograph /l=left psth_thresh
			endif
		endif
		ModifyGraph rgb(psth_thresh)=(0,0,0), lstyle(psth_thresh)=1
	endif
	mafprocessbutton("")
End

Function FilterCheckProc(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	CheckBox CheckFreqFilter value=0, win=mafPSTH
	CheckBox CheckBoxFilter value=0, win=mafPSTH
	CheckBox $ctrlName value=1, win=mafPSTH
	mafprocessbutton("")
End


Function ReprocessField(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	
	strswitch (ctrlname)
		case "PSTHThresh":
			NVAR EPSC_ddtthreshold=EPSC_ddtthreshold
			wave psth_thresh=psth_thresh
			if (exists ("psth_thresh"))
				psth_thresh = EPSC_ddtthreshold
			endif	
			break
		case "setvarFilterLow":
		case "setvarFilterHigh":
			filtercheckproc ("CheckFreqFilter", 1)
			break
		case "setvarFilterBox":
			filtercheckproc ("CheckBoxFilter", 1)
			break
	endswitch
	mafprocessbutton("")
End
Function ReprocessCheck(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	mafprocessbutton("")
End


Function mafprocessbutton(ctrlName) : ButtonControl	// Process
	string ctrlName

	SVAR minibase=minibase
	NVAR currentw=currentw, wavenumber=wavenumber
	NVAR EPSC_ddtthreshold=EPSC_ddtthreshold
	string wavename = minibase + num2str (currentw)
	string mywinlist
	variable ILoadedIt
	
	if (strlen (minibase) == 0 %| currentw < 0)
		return (-1)
	endif
	ILoadedIt = LoadWaveIfNeeded (wavename)
	if (ILoadedIt == -1)
		abort "Couldn't find wave \"" + wavename + "\""
	endif
	
	wave w = $wavename
	duplicate /o w psth_w
	wavenumber = currentw
	if (ILoadedIt == 1)
		killwaves w
	endif
	ddtAndSmooth ()
	findPeaks ()
	duplicate /o $(minibase + num2str (currentw)+"_peak") psth_peak
	duplicate /o $(minibase + num2str (currentw)+"_x") psth_x

	
	mywinlist = WinList ("InspectWindow", ";", "WIN:1")
	if (strlen (mywinlist) == 0)
		Display /W=(5,164,795,392) psth_peak vs psth_x
		DoWindow/C InspectWindow
		textbox /b=1/f=0/n=texthead "\\{\"%s%g\",minibase,currentw}"
		AppendtoGraph psth_w
		AppendtoGraph/L=left2 psth_dw
		make /o/n=2 psth_thresh
		psth_thresh = EPSC_ddtthreshold
		
		ModifyGraph mode(psth_peak)=3, marker(psth_peak)=19, rgb(psth_peak)=(0,0,0)
		ModifyGraph lblPos=61, freePos(left2)=0
		setaxis left -200, 50
		setaxis left2 -50000, 50000
		if (checkval ("CheckTrigger2", "mafPSTH") == 1)
			appendtograph/l=left3 psth_d2w, psth_thresh
			setaxis left3 -1e9, 1e9
			ModifyGraph freePos(left3)=0
			ModifyGraph axisEnab(left)={0,0.30}, axisEnab(left2)={0.35,.65}, axisEnab(left3)={0.70,1}
		else
			ModifyGraph axisEnab(left)={0,0.45}, axisEnab(left2)={0.55,1}
			appendtograph /l=left2 psth_thresh
		endif
		ModifyGraph rgb(psth_thresh)=(0,0,0), lstyle(psth_thresh)=1	
	endif
	SetScale/I x 0,rightx (psth_w),"", psth_thresh
End


//Function mafrunthru(ctrlName) : ButtonControl	// Run Thru
//	String ctrlName
//	string wavename
//	SVAR minibase=minibase
//	NVAR currentw=currentw
//	NVAR wavenumber=wavenumber
//	NVAR mstart=psth_start
//	NVAR mend=psth_end
//	variable ILoadedIt = 0
//	variable i=0
//	variable j
//	variable np
//	wavenumber=mstart
//	make/o/n=1000 am,fre,isi
//	am=nan;fre=nan;isi=nan
//	do
//		mafprogress ((wavenumber - mstart) / (mend - mstart))
//		// is this a wave to be processed, i.e. is it in the doTrials list and not in the skipTrials list?
//		if (((numpnts (psth_dotrials) == 0) %| (findwaveval (psth_dotrials, wavenumber) != -1)) %& (findwaveval (psth_skiptrials, wavenumber) == -1))
//			wavename = minibase + num2str (wavenumber)
//			ILoadedIt = LoadWaveIfNeeded (wavename)
//			if (ILoadedIt != -1)				// i.e. found it
//				wave w = $wavename
//				duplicate /o w psth_w
//				ddtAndSmooth ()
//				findPeaks ()
//				duplicate /o $(wavename +"_peak") psth_peak
//				duplicate /o $(wavename +"_x") psth_x
//					fre[wavenumber]=(numpnts(psth_peak)/5)
//					wavestats/q psth_peak
//					am[wavenumber]=v_avg
//					j=0
//					do
//						np=numpnts(psth_x)
//						isi[i]=(psth_x[j+1]-psth_x[j])
//						i+=1
//						j+=1
//					while (j <= (np-2) )
//				if (ILoadedIt == 1)
//					killwaves w
//					ILoadedIt = 0
//				endif
//			endif
//		endif
//		wavenumber +=1
//	while (wavenumber <= mend)
//	redimension/n=(i) isi
//	RasterButtonProc ("")
//	mafprocessbutton ("")
//End


// more robyn changes:  isi here changed to interval
Function mafrunthru(ctrlName) : ButtonControl    // Run Thru
    String ctrlName
    string wavename
    SVAR minibase=minibase
    NVAR currentw=currentw
    NVAR wavenumber=wavenumber
    NVAR mstart=psth_start
    NVAR mend=psth_end
    variable ILoadedIt = 0
    variable i=0
    variable j
    variable np
    wavenumber=mstart
    make/o/n=1000 am,fre,interval,robyn_amp
    am=nan;fre=nan;interval=nan;robyn_amp=nan
    do
        mafprogress ((wavenumber - mstart) / (mend - mstart))
        // is this a wave to be processed, i.e. is it in the doTrials list and not in the skipTrials list?
        if (((numpnts (psth_dotrials) == 0) %| (findwaveval (psth_dotrials, wavenumber) != -1)) %& (findwaveval (psth_skiptrials, wavenumber) == -1))
            wavename = minibase + num2str (wavenumber)
            ILoadedIt = LoadWaveIfNeeded (wavename)
            if (ILoadedIt != -1)                // i.e. found it
                wave w = $wavename
                duplicate /o w psth_w
                ddtAndSmooth ()
                findPeaks ()
                duplicate /o $(wavename +"_peak") psth_peak
                duplicate /o $(wavename +"_x") psth_x
                    fre[wavenumber]=(numpnts(psth_peak)/5)
                    wavestats/q psth_peak
                    am[wavenumber]=v_avg
                    j=0
                    do
                        np=numpnts(psth_x)
                        interval[i]=(psth_x[j+1]-psth_x[j])
                        robyn_amp[i] = -1*psth_peak[j]        //added by robyn 11-4-10
                                //  yay! this fixes my problems. provides raw interval & amp waves with "run thru" button
                                // not filtered by additional criteria in "avg mini" button, but that's ok. avoids many other bugs 
                        i+=1
                        j+=1
                    while (j <= (np-2) )
                if (ILoadedIt == 1)
                    killwaves w
                    ILoadedIt = 0
                endif
            endif
        endif
        wavenumber +=1
    while (wavenumber <= mend)
    redimension/n=(i) interval
    RasterButtonProc ("")
    mafprocessbutton ("")
End


function killthisglitchonoriginal (n)
	variable n
	variable ILoadedIt = 0, tempval
	SVAR minibase=minibase
	NVAR currentw=currentw
	string wavename = minibase + num2str (currentw)

	if (!exists (wavename))
		loadwave /q/p=home wavename + ".bwav"
		ILoadedIt = 1
	endif
	wave w=$wavename
	tempval = x2pnt (w, xcsr (a))
	w[tempval, tempval + n] = 0
	if (ILoadedIt == 1)
		save /o w
		killwaves w
	endif
	mafprocessbutton ("")
end
